#include "lightgen.h"
#include "util.h"
#include "wad.h"



std::list<wSector_t *> AllDaySectors;
std::list<wSector_t *> AllNightSectors;
std::ofstream OutFile;

const int StartTag = 10000;

void LG_OpenOutFile()
{
	OutFile.open("output.wl", std::ios::out);
}

void LC_Exit(int code)
{
	exit(code);
}

void LG_ReadSectors(wFile_t *file, std::string mapname, std::list<wSector_t *> &sectors)
{
	const int SECTOR_SIZE = 26;
	// clear everything
	if (!sectors.empty()) {
		for (std::list<wSector_t *>::iterator it = sectors.begin(); it != sectors.end(); ++it) {
			delete *it;
			sectors.pop_front();
		}
	}

	wEntry_t *sectors = Wad_FindEntry(file, "SECTORS",
		Wad_FindEntry(file, mapname.c_str(), NULL, false), false);
	if (sectors) {
		uint8_t *sectLump = (uint8_t *)malloc(sectors->size * sizeof(uint8_t)); // SECTORS's data
		fseek(file->file, sectors->offset, SEEK_SET);
		std::cout << fread((void*)sectLump, 1, sectors->size, file->file);

		for (size_t i = 0; i < sectors->size; i += SECTOR_SIZE) { //
			wSector_t *sector = new wSector_t;
			sector->FloorHeight = read2bytes_mem((void *)(sectLump + i));
			sector->CeilingHeight = read2bytes_mem((void *)(sectLump + i + 0x02));
			memcpy((void *)(sector->FloorTexture), (void *)(sectLump + i + 0x04), 8);
			memcpy((void *)(sector->CeilingTexture), (void *)(sectLump + i + 0x0C), 8);
			sector->Light = read2bytes_mem((void *)(sectLump + i + 0x14));
			sector->Tag = read2bytes_mem((void *)(sectLump + i + 0x18));
			if (sector->Tag >= StartTag) {
				sector.push_back(sector);
			} else {
				delete sector;
			}
			
		}
		delete [] sectLump;
	}
}

void LG_GenerateGeometry()
{
	const int dayintics = 1024;
	const int numsect = AllSectors.size();
	const int daytonight[] = {240, 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64};
	OutFile << "#\"standard.h\"" << std::endl;
	OutFile << "#\"spawns.h\"" << std::endl;
	
	// Voodoo controller
	
	OutFile << "Voodoo_Evening(tag)" << std::endl;
	OutFile << "{" << std::endl;
	OutFile << "set(\"vBoxSize\", mul(add(div(" << numsect << ", 32), 1), 32))" << std::endl;
	OutFile << "set(\"voodoos\", div(get(\"vBoxSize\"), 32))" << std::endl;
	OutFile << "typeline(157,tag, step(-32, 0))" << std::endl;
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	OutFile << "typeline(157,1099, step(-32, 0))" << std::endl;
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	OutFile << "{eq(tag, 1000) ? set(\"lightlevel\", 64) : \
		{eq(tag, 1001) ? set(\"lightlevel\", 80) : \
		{eq(tag, 1002) ? set(\"lightlevel\", 96) : \
		{eq(tag, 1003) ? set(\"lightlevel\", 112) : \
		{eq(tag, 1004) ? set(\"lightlevel\", 128) : \
		{eq(tag, 1005) ? set(\"lightlevel\", 144) : \
		{eq(tag, 1006) ? set(\"lightlevel\", 160) : \
		{eq(tag, 1007) ? set(\"lightlevel\", 176) : \
		{eq(tag, 1008) ? set(\"lightlevel\", 192) : \
		{eq(tag, 1009) ? set(\"lightlevel\", 208) : \
		{eq(tag, 1010) ? set(\"lightlevel\", 224) : \
		{eq(tag, 1011) ? set(\"lightlevel\", 240) : set(\"lightlevel\", 0)}}}}}}}}}}}}" << std::endl;
	
	int counter = 1100;
	for (std::list<wSector_t *>::iterator it = AllSectors.begin(); it != AllSectors.end(); ++it) {
		wSector_t &sector = **it;
		OutFile << "{lessthaneq(" << sector.Light << ", get(\"lightlevel\")) ? \
			movestep(-1, 0) : typeline(157," << counter++ << ", step(-1, 0))}" << std::endl;
	}
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	
	counter = 2200;
	for (std::list<wSector_t *>::iterator it = AllSectors.begin(); it != AllSectors.end(); ++it) {
		wSector_t &sector = **it;
		OutFile << "{lessthaneq(" << sector.Light << ", get(\"lightlevel\")) ? \
			movestep(-1, 0) : typeline(157," << counter++ << ", step(-1, 0))}" << std::endl;
	}
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), 30)" << std::endl;
	OutFile << "}" << std::endl;
	OutFile << "GenVoodooController" << std::endl;
	OutFile << "{" << std::endl;
	OutFile << "set(\"vBoxSize\", mul(add(div(" << AllSectors.size() << ", 32), 1), 32))" << std::endl;
	OutFile << "set(\"voodoos\", div(get(\"vBoxSize\"), 32))" << std::endl;
	OutFile << "movestep(0, " << dayintics <<")" << std::endl;
	OutFile << "movestep(-16, -64)" << std::endl;
	OutFile << "Voodoo_Evening(1000)" << std::endl;
	OutFile << "Voodoo_Evening(1001)" << std::endl;
	OutFile << "Voodoo_Evening(1002)" << std::endl;
	OutFile << "Voodoo_Evening(1003)" << std::endl;
	OutFile << "Voodoo_Evening(1004)" << std::endl;
	OutFile << "Voodoo_Evening(1005)" << std::endl;
	OutFile << "Voodoo_Evening(1006)" << std::endl;
	OutFile << "Voodoo_Evening(1007)" << std::endl;
	OutFile << "Voodoo_Evening(1008)" << std::endl;
	OutFile << "Voodoo_Evening(1009)" << std::endl;
	OutFile << "Voodoo_Evening(1010)" << std::endl;
	OutFile << "Voodoo_Evening(1011)" << std::endl;
	OutFile << "movestep(inv(add(get(\"vBoxSize\"), 1)), sub(inv("<< dayintics <<"), inv(add(get(\"vBoxSize\"), 1))))" << std::endl;
	OutFile << "typesector(0, 1012, " << std::endl;
	OutFile << "step(add(get(\"vBoxSize\"), 2), 0)" << std::endl;
	OutFile << "step(0, "<< dayintics <<")" << std::endl;
	OutFile << "step(inv(add(get(\"vBoxSize\"), 2)), 0)" << std::endl;
	OutFile << "step(0, inv("<< dayintics <<"))" << std::endl;
	OutFile << "rightsector(0, 128, 255) )" << std::endl;
	OutFile << "movestep(0, "<< dayintics <<")" << std::endl;
	OutFile << "typeline(252,1012, step(0, -64))" << std::endl;
	OutFile << "player1start" << std::endl;
	OutFile << "movestep(17, 0)" << std::endl;
	OutFile << "for(1,get(\"voodoos\"), thing movestep(32, 0))" << std::endl;
	OutFile << "}" << std::endl;
	
	OutFile << "GetLightManager" << std::endl;
	OutFile << "{" << std::endl;
	OutFile << "top(\"SKY3\")" << std::endl;
	OutFile << "step(24, 0)" << std::endl;
	OutFile << "step(0, " << 2*numsect+1 << ")" << std::endl;
	OutFile << "step(-24, 0)" << std::endl;
	OutFile << "step(0," << -(2*numsect+1) <<")" << std::endl;
	OutFile << "mergesectors" << std::endl;
	OutFile << "typesector(0, 1099, rightsector(-10000, 10000, 255))" << std::endl;
	OutFile << "mergesectors" << std::endl;
	
	
	int count = 0;
	counter = 2200;
	for (std::list<wSector_t *>::iterator it = AllSectors.begin(); it != AllSectors.end(); ++it) {
		wSector_t &sector = **it;
		OutFile << "step(-1, 0)" << std::endl;
		OutFile << "step(0, 1)" << std::endl;
		OutFile << "step(1, 0)" << std::endl;
		OutFile << "step(0, -1)" << std::endl;
		OutFile << "typesector(0, " << counter++ << ", leftsector(-10000, 10000, 255))" << std::endl;
		OutFile << "movestep(-1, 0)" << std::endl;
		OutFile << "typeline(271, " << sector.Tag << ", step(-1, 0))" << std::endl;
		OutFile << "typeline(242, " << sector.Tag << ", step(1, 1))" << std::endl;
		OutFile << "step(0, -1)" << std::endl;
		OutFile << "floor(\"";
		OutFile.write(sector.FloorTexture, std::min<int>(8, strlen(sector.FloorTexture)));
		OutFile << "\")" << std::endl;
		OutFile << "ceil(\"";
		OutFile.write(sector.CeilingTexture, std::min<int>(8, strlen(sector.CeilingTexture)));
		OutFile << "\")" << std::endl;
		OutFile << "typesector(0," << 1100 + count << ", leftsector("
			<< sector.FloorHeight + 1 << ", " << sector.FloorHeight + 1 << ", " << sector.Light<<"))" << std::endl;
		OutFile << "movestep(1, 2)" << std::endl;
		++count;
	}
	OutFile << "}" << std::endl;
}

static void Usage()
{
	fprintf(stdout, "Usage: boomlightgen [OPTIONS] mapname daywad nightwad\n");
	
	fprintf(stdout, "  mapname\t Map to use\n");
	fprintf(stdout, "  daywad\t Wad used for day light\n");
	fprintf(stdout, "  daywad\t Wad used for night light\n");
} 

int LG_Main(int argc, char **argv)
{
	fprintf(stdout, "boomlightgen 0.1 by cybermind - a tool to generate realistic day/night cycle for Boom wads.\n");
	if (argc < 4) {
		Usage();
		system("pause");
		WC_Exit(1);
	}
	std::string mapname(argv[1]);
	std::string daywad(argv[2]);
	std::string nightwad(argv[3]);
	wFile_t *daywadfile = Wad_Open(daywad.c_str());
	wFile_t *nightwadfile = Wad_Open(nightwad.c_str());
	if (!daywadfile || !nightwadfile) {
		LC_Exit(1);
	}

	LG_ReadSectors(daywadfile, mapname, AllDaySectors);
	LG_ReadSectors(nightwadfile, mapname, AllNightSectors);
	LG_OpenOutFile();
	LG_GenerateGeometry();
	OutFile.close();
	return 0;
} 

int main(int argc, char **argv)
{
	return LG_Main(argc, argv);
}